from django.shortcuts import render, redirect
from django.http import JsonResponse, HttpResponseBadRequest
from django.views.decorators.http import require_POST
from django.views.decorators.csrf import csrf_exempt
import requests
from .models import FavouriteMovie
from django.conf import settings

API_KEY = "93ba62b6"  # your OMDB API key

def home(request):
    return render(request, "index.html")

def search_movies(request):
    query = request.GET.get("q")
    if not query:
        return JsonResponse({"error": "Missing query"}, status=400)
    url = f"http://www.omdbapi.com/?apikey={API_KEY}&s={query}"
    res = requests.get(url, timeout=10)
    return JsonResponse(res.json())

@require_POST
def add_to_favourites(request):
    imdb_id = request.POST.get("imdb_id") or request.body.decode('utf-8')
    # handle form-encoded or JSON; try form first
    if not imdb_id:
        return JsonResponse({'message': 'Missing imdb_id'}, status=400)
    # For simplicity, accept form POST fields
    imdb_id = request.POST.get('imdb_id')
    title = request.POST.get('title')
    year = request.POST.get('year')
    poster = request.POST.get('poster')

    if not imdb_id or not title:
        return JsonResponse({'message': 'Missing data'}, status=400)

    if FavouriteMovie.objects.filter(imdb_id=imdb_id).exists():
        return JsonResponse({'message': 'Already in favourites'})

    FavouriteMovie.objects.create(imdb_id=imdb_id, title=title, year=year, poster=poster)
    return JsonResponse({'message': 'Added to favourites'})

def favourites(request):
    movies = FavouriteMovie.objects.all()
    return render(request, "favourites.html", {"movies": movies})

@require_POST
def remove_favourite(request):
    imdb_id = request.POST.get('imdb_id')
    if not imdb_id:
        return HttpResponseBadRequest("Missing imdb_id")
    FavouriteMovie.objects.filter(imdb_id=imdb_id).delete()
    return JsonResponse({'message': 'Removed'})
